/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.audio;

import com.tino1b2be.audio.AudioFile;
import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.audio.WavFileException;
import com.tino1b2be.audio.WavFileUtil;
import java.io.File;
import java.io.IOException;

public class WavFile
extends WavFileUtil
implements AudioFile {
    public WavFile(WavFileUtil other) {
        this.setFile(other.getFile());
        this.setIoState(other.getIoState());
        this.setBytesPerSample(other.getBytesPerSample());
        this.setNumFrames(other.getNumFrames());
        this.setoStream(other.getoStream());
        this.setiStream(other.getiStream());
        this.setFloatScale(other.getFloatScale());
        this.setFloatOffset(other.getFloatOffset());
        this.setWordAlignAdjust(other.isWordAlignAdjust());
        this.setNumChannels(other.getNumChannels());
        this.setSampleRate(other.getSampleRate());
        this.setBlockAlign(other.getBlockAlign());
        this.setValidBits(other.getValidBits());
        this.setBuffer(other.getBuffer());
        this.setBufferPointer(other.getBufferPointer());
        this.setBytesRead(other.getBytesRead());
        this.setFrameCounter(other.getFrameCounter());
    }

    public WavFile(File exportFile, int numChannels, long numFrames, int resolution, int Fs) throws IOException, WavFileException {
        WavFileUtil other = WavFileUtil.newWavFile(exportFile, numChannels, numFrames, 16, Fs);
        this.setFile(other.getFile());
        this.setIoState(other.getIoState());
        this.setBytesPerSample(other.getBytesPerSample());
        this.setNumFrames(other.getNumFrames());
        this.setoStream(other.getoStream());
        this.setiStream(other.getiStream());
        this.setFloatScale(other.getFloatScale());
        this.setFloatOffset(other.getFloatOffset());
        this.setWordAlignAdjust(other.isWordAlignAdjust());
        this.setNumChannels(other.getNumChannels());
        this.setSampleRate(other.getSampleRate());
        this.setBlockAlign(other.getBlockAlign());
        this.setValidBits(other.getValidBits());
        this.setBuffer(other.getBuffer());
        this.setBufferPointer(other.getBufferPointer());
        this.setBytesRead(other.getBytesRead());
        this.setFrameCounter(other.getFrameCounter());
    }

    @Override
    public int read(double[] buffer) throws AudioFileException {
        try {
            return super.readFrames(buffer, buffer.length);
        }
        catch (WavFileException | IOException e) {
            throw new AudioFileException(e.getMessage());
        }
    }

    @Override
    public int read(double[][] buffer) throws AudioFileException {
        try {
            return super.readFrames(buffer, buffer[0].length);
        }
        catch (WavFileException | IOException e) {
            throw new AudioFileException(e.getMessage());
        }
    }

    @Override
    public String getFileProperties() {
        return null;
    }

    @Override
    public int writeFrames(double[][] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return super.writeFrames(sampleBuffer, numFramesToWrite);
    }

    @Override
    public int writeFrames(double[] sampleBuffer, int numFramesToWrite) throws IOException, WavFileException {
        return super.writeFrames(sampleBuffer, numFramesToWrite);
    }

    @Override
    public long getFramesRemaining() {
        return super.getFramesRemaining();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public int writeFrames(int[][] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        return super.writeFrames(sampleBuffer, offset, numFramesToWrite);
    }

    @Override
    public int writeFrames(int[] sampleBuffer, int offset, int numFramesToWrite) throws IOException, WavFileException {
        return super.writeFrames(sampleBuffer, offset, numFramesToWrite);
    }
}

